******************************************************************************
*               Source code for the HP38G TICKING CLOCK library
*               Version 1.0 Released in February 2003.
*               Copyright (c) 2003 by Jordi Hidalgo. All rights reserved.
*               Email: johil@tv3mail.com
*               Address: Avda Jaume Recoder, 80, 1-4
*                        08302, Matar
*                        Barcelona, Spain
******************************************************************************

* The library id number is 702h, 1794d. By using romids greater than or
* equal to 700h (700 and 701 are built-in libs) you have the possibility
* to customize the help displayed by HELPWITH and to control the parsing
* of arguments.

xROMID 702

* List of the 58 unsupported entry points used. ERRTRAP2 is actually the
* correct entry for ERRTRAP. The one included in the official SUPROM38.A
* is buggy: it is a jump table entry (#81A13h), which ERRJMP cannot find
* in the runstream because it looks for the actual ERRTRAP at 04E98.

ASSEMBLE

=2NULLLAM{}     EQU     #A5E04
=?BlinkCursor   EQU     #3E76D
=?DispStack     EQU     #87FA1
=?DispStatus    EQU     #87CAB
=ALARM?         EQU     #3EA9C
=ALARMxcp       EQU     #3E870
=ATTNxcp        EQU     #3E803
=AddVertSync    EQU     #19CE8
=AtUserStack    EQU     #3D4A5
=BusyFalse      EQU     #3E993
=CLKOFF         EQU     #0CC7E
=CLKON          EQU     #0CC6D
=CURSORBLINK    EQU     #34BC3
=CURSORPLUS     EQU     #34DA3
=ClrDAsOK       EQU     #26CCD
=D0->Sft1       EQU     #01C82
=DA1OK?NOTIT    EQU     #26AD9
=DA2aOK?NOTIT   EQU     #26AF2
=DA2bOK?NOTIT   EQU     #26B0B
=DArrow         EQU     #3F625
=DATE           EQU     #0C9A6
=Date>d$        EQU     #0CD6D
=DispEditLine   EQU     #88356
=DoCAlarmKey    EQU     #3EC76
=DoKeyOb        EQU     #3C96F
=DoLabel        EQU     #3DF5D
=DoMenuKey2NS   EQU     #3F35D
=DoMenuKey3NS   EQU     #3F376
=ERRTRAP2       EQU     #04E98
=GETDF          EQU     #04A21
=GOTKEY         EQU     #3E975
=H/WKey>KeyOb   EQU     #3C792
=HStackPtr!     EQU     #3D597
=HStackPtr@     EQU     #3D5A7
=HiLitePtr!     EQU     #3D557
=HiLitePtr@     EQU     #3D567
=LCDxcp         EQU     #3E821
=LiteSlp        EQU     #048F2
=LSKey1.2       EQU     #3FAB0
=LSKey1.3       EQU     #3FAC9
=NOBLINK        EQU     #40798
=NoIgnoreAlm    EQU     #40984
=PurgeLib#      EQU     #27822
=SAVELCD?       EQU     #3E9F2
=SETANNUN       EQU     #01E88
=SLEEPxcp       EQU     #3E8D0
=SysErrorTrap   EQU     #25C9F
=T1COUNT#0?     EQU     #34DD4
=TIME&COUNT     EQU     #3EBDB
=TIMEOUT?       EQU     #3EA7A
=TOD            EQU     #0C992
=TOD>t$         EQU     #0CDFE
=UART?          EQU     #3EA44
=UARTxcp        EQU     #3E8E4
=UpArrow        EQU     #3F48A
=WindowPtr!     EQU     #3D577
=WindowPtr@     EQU     #3D587
=XCPN?          EQU     #3E9A7

RPL

* ROM Pointer declarations. The library has two typeable commands CLK
* and DELCLK

EXTERNAL xCLK
EXTERNAL xDELCLK
EXTERNAL nSysDisplay
EXTERNAL nGetKeyOb
EXTERNAL RunningErr

******************************************************************************

* This nibble means that CLK is a command that has help data

ASSEMBLE
        CON(1)  4
RPL

xNAME CLK
::
 CK0                            ( No arguments )

 ' LAM ~clk                     ( if local variable ~clk exists, i.e. CLK )
 @LAM casedrop                  ( already running, then )
 RunningErr                     ( displays an error message and exits )

 FALSE { LAM ~clk } BIND        ( otherwise local var ~clk is created, and )
                                ( contains FALSE initially )

* User flags:      40              41              42              43
* Clear      Time displayed  12-hour format  mm/dd/yy format  normal video
* Set        Date displayed  24-hour format  dd.mm.yy format  inverse video

* Users flags are used instead of system flags because most system flags
* are cleared by SysErrorTrap when a user-level error occurs, such as 9/0.
* As user flags are only cleared by a coldstart (memory clear), the clock
* settings are saved all the time.

 FORTY TestUserFlag ?SKIP       ( if time is to be displayed, then the )
 CLKON                          ( one-second clock display update is enabled )

 BEGIN                          ( Here begins the replacement for the system )
                                ( outer loop, which will finish when ~clk is )
                                ( TRUE )

 nSysDisplay                    ( New SysDisplay routine, a ROMPTR, see below)
 nGetKeyOb                      ( New GetKeyOb routine, idem )

* The stack level one now has the procedure corresponding to the last key
* pressed. This is therefore a good opportunity to redefine a few keys,
* before calling DoKeyOb. The following program checks if the key pressed
* was one of these: SK2, SK3, SHIFT SK2, SHIFT SK3, Up Arrow or Down Arrow.
* If so, its action is changed by placing another program on the stack,
* which will be evaluated by DoKeyOb later. Unlike the HP48/49, TakeOver is
* not needed in these programs.

 ::
  ' DoMenuKey2NS EQcasedrop     ( If SK2 was pressed, )
  ::
   '                            ( then puts this routine on the stack instead: )
   ::                           ( a Time/Date toggler )
     FORTY DUP UserITE
     :: ClrUserFlag CLKON ;
     :: SetUserFlag CLKOFF ;    ( the 1-sec interrupt is disabled if Date )
                                ( is selected to be displayed: This means )
                                ( that Date is not updated at midnight )
   ;
  ;
  ' DoMenuKey3NS EQcasedrop     ( Otherwise, if SK3 was pressed, )
  ::
   '                            ( puts on the stack: )
   ::                           ( a 12-hr/24-hr toggler if time is displayed )
     FORTY UserITE              ( or a date format toggler if date is disp. )
     FORTYTWO FORTYONE
     DUP UserITE
     ClrUserFlag SetUserFlag
   ;
  ;
  ' LSKey1.2 EQcasedrop         ( Else if SHIFT SK2 was pressed, )
  ::
   '                            ( puts on the stack: )
   ::
     FORTYTHREE DUP             ( a normal/inverse video toggler )
     UserITE
     ClrUserFlag SetUserFlag
   ;
  ;
  ' LSKey1.3 EQcasedrop         ( Else if SHIFT SK3 was pressed, )
  ::
   '                            ( puts on the stack a program.. )
   ::
     TRUE ' LAM ~clk STOLAM     ( ..that stores TRUE in ~clk, signal to exit )
   ;
  ;

* The up and down arrow keys are modified so that they don't call the old
* SysDisplay. They call it because they can alter any part of the display:
* the menu, history and title areas. The only change in the built-in routines
* is to replace SysDisplay with nSysDisplay.

  ' UpArrow  EQcasedrop         ( If the up-arrow key was pressed, )
  ::
   '
   ::                           ( this is its new action )
    DEPTH HStackPtr@
    #=case
    DoBadKey
    REPEATERCH ELEVEN
    ::
     ::
      DEPTH #2-
      HStackPtr@
      #=case
      SetDAsNoCh
      HStackPtr@ #1+ HStackPtr!
      HiLitePtr@ FOUR
      #=case
      :: WindowPtr@ #1+ WindowPtr! ;
      HiLitePtr@ #1+ HiLitePtr!
     ;
     2NULLLAM{} BIND
     nSysDisplay                ( This is the only modification to UpArrow )
     2GETLAM 1GETABND
    ;
    SetDAsNoCh
   ;
  ;

* The same applies to the down arrow key:

  ' DArrow EQcasedrop           ( If it was the down-arrow key that was )
  ::
   '
   ::                           ( pressed, then this is what will be executed )
    HStackPtr@
    #0=case
    DoBadKey
    REPEATERCH SEVENTEEN
    ::
     ::
      HStackPtr@
      #0=case
      SetDAsNoCh
      HStackPtr@
      #1=case
      :: ZEROZERO HStackPtr! HiLitePtr! ;
      HStackPtr@ #1- HStackPtr!
      HiLitePtr@
      #1=case
      :: WindowPtr@ #1- WindowPtr! ;
      HiLitePtr@ #1- HiLitePtr!
     ;
     2NULLLAM{} BIND
     nSysDisplay                ( This is the only modification to DArrow )
     2GETLAM 1GETABND
    ;
    SetDAsNoCh
   ;
  ;
 ;
 ERRSET
 DoKeyOb                        ( Executes key presses )
 ERRTRAP2
 SysErrorTrap                   ( Any error is handled here)
 LAM ~clk
 UNTIL                          ( Loops until ~clk is TRUE )

* Now you are leaving the application. Make sure the 1-second interrupt
* is disabled, so as not to interfere with data tranfers or the beeper.

 CLKOFF

;

* This is the parser data for a command with no arguments.

::
 'Rapndit
 xCLK
 TrueTrue
;

* And this is the help string displayed by HELPWITH CLK
* in a message box: 5 rows of 15 chars max.

$ "SK2: Time/Date SK3: 12/24hr or     mm.dd/dd.mm \8ESK2: Light \8ESK3: Quits"

******************************************************************************

* The following command is provided in order to let the user purge this
* library, since there is no accompanying aplet this time.

ASSEMBLE
        CON(1)  4               Command with help
RPL

xNAME DELCLK
::
 CK0                            ( No args )
 '                              ( The following program is put on the stack )
 ::
  AtUserStack                   ( Clears last saved command name. No args )
  '
  LAM ~clk
  @LAM
  casedrop                      ( If CLK is running then )
  RunningErr                    ( displays an error message and exits )
  # 702 PurgeLib#               ( lib 1794 purged )
 ;
 TOTEMPOB                       ( The above program is copied to TEMPOB area )
 COLA_EVAL                      ( and run from there without returning )
;

* Simple parser data for a command without arguments

::
 'Rapndit
 xDELCLK
 TrueTrue
;

* Help string for DELCLK

$ "Purges the lib v1.0 \A9 2003 by   Jordi Hidalgo"

******************************************************************************

* This is the SysDisplay replacement. The subroutine changed is ?DispMenu.
* There are two changes described below. Note that there's no need to display
* the clock here.

NULLNAME nSysDisplay
::
 DA2aOK?NOTIT ?DispStack        ( Draws the history, )
 DA1OK?NOTIT ?DispStatus        ( title area )
 DA2bOK?NOTIT DispEditLine      ( and command line if required )

 DA3OK?NOTIT                    ( If menu needs to be redrawn: )
 ::
  KEYINBUFFER?                  ( If a keystroke is waiting to be processed, )
  case SetDA3Bad                ( wait: process the key first )

  TURNMENUON                    ( Turns on the menu display )

* This is FLOSS (335E0) which draws the five columns of eight blank pixels
* that separate the menu labels. To avoid annoying flickers, the second
* separator is not drawn:

  CODE
        CD0EX
        RSTK=C
        GOSBVL  =D0->Sft1       Pointer to HARDBUFF2, the menu grob
        D0=D0-  2
        LC(1)   7
        CSRC
        LA(2)   #7D
-       D0=D0+  7
        GOSBVL  #33629          Draws nth row of first separator
        D0=D0+  6               Skips second separator
        GOSBVL  #33629          Draws third
        GOSBVL  #3363A          Draws forth
        GOSBVL  #33629          Draws fifth
        C=C-1   S
        GONC    -               This is done 8 times (7 to 0), one for each row
        C=RSTK
        CD0EX                   Restores D0
        A=DAT0  A               and exits to RPL
        D0=D0+  5
        PC=(A)
  ENDCODE

* The other modification is to avoid updating the second and third menu labels,
* again in order to avoid flickers.

  # 6E SIX                      ( 6th menu label column number and SK number )
  # 58 FIVE                     ( 5th )
  # 42 FOUR                     ( 4th )
                                ( 3rd -# 2C THREE- & 2nd -# 16 TWO- omitted )
  ZERO ONE                      ( 1st )

  FOUR
  ZERO_DO (DO)
  GETDF DoLabel                 ( For each label, get definition and draw )
  LOOP
  AddVertSync
  SetDA3Valid
 ;                              ( End of ?DispMenu replacement )
 ClrDAsOK                       ( Signals entire display should be redrawn )
;

******************************************************************************

* This is the GetKeyOb replacement. It is now, just before the calc is idle
* waiting for a key press, that the code that displays the clock must be run:
* in SHUTDN, between SETANNUN and LiteSlp. The rest remains untouched.

NULLNAME nGetKeyOb
::
 ?BlinkCursor
 ::
  NoIgnoreAlm
  ::
   ATTN? case BusyFalse
   GETTOUCH case GOTKEY
   TIME&COUNT CURSORPLUS CURSORBLINK
   BEGIN
   XCPN?
   IT
   :: 2RDROP BusyFalse ;
   T1COUNT#0?
   ?SKIP
   CURSORBLINK
   ::
    SETANNUN

* Here's the routine that displays the clock on the menu area. This routine
* should not use the data stack so as not to increase the frequency of GC's.
* Not done in this version, and not really needed on the HP38G because it's
* a fast machine (most ROM not covered, only DEMO) and having just 23k of
* available memory, GC is fast.

* This is a double-width blank menu label

    ASSEMBLE
        NIBHEX E1B20F600080000B2000000000000
        NIBHEX 00000000000000000000000000000
        NIBHEX 00000000000000000000000000000
        NIBHEX 00000000000000000000000000000
    RPL
    TOTEMPOB

    FORTY UserITE               ( If the date is to be displayed: )
    ::
     FORTYTWO UserITE           ( If dd.mm.yy format: )
     ::
      FORTYTWO SetSysFlag       ( DATE and Date>d$ are affected by flag -42 )
      DATE Date>d$              ( "07.02.03" )
      FORTYTWO ClrSysFlag       ( DISPTIME expects sys flag 42 to be clear )
      $>grob                    ( creates a grob using the small font )
      EIGHT                     ( which will be displayed at column 8 )
     ;
     ::                         ( Else, if mm/dd/yy format: )
      DATE Date>d$              ( Sys flag 42 can be assumed to be clear )
      $>grob                    ( grob created from "02/07/03" )
      SIX                       ( disp. at col 6, as this grob is bigger )
     ;
    ;
    ::                          ( It is the time that is displayed )
     FORTYONE UserITE           ( If 24-hour format: )
     ::
      FORTYONE SetSysFlag       ( TOD and TOD>t$ are affected by flag -41 )
      TOD TOD>t$                ( " 05:19:24" )
      FORTYONE ClrSysFlag       ( System flag restored )
      CDR$                      ( "05:19:24" )
      $>grob
      EIGHT                     ( same size as "07.02.03" )
     ;
     ::                         ( 12-hour format )
      TOD TOD>t$                ( Sys flag 41 can be assumed to be clear )
      $>grob                    ( grob from "05:19:24A" )
      SIX                       ( same size as "02/07/03" )
     ;
    ;
    3PICKSWAP TWO               ( The clock grob is stored in the blank grob )
    GROB!                       ( above at coordinates EIGHT/SIX TWO )

    FORTYTHREE TestUserFlag     ( If inverse video active, everything is done )
    ?SKIP                       ( otherwise: )
    ::
     INVGROB                    ( normal video )
     ZEROZERO FORTYFOUR ONE     ( First row - where the dir bars are - )
     GROB!ZERO                  ( is cleared )
    ;

    HARDBUFF2 TWENTYTWO ZERO
    GROB!                       ( Final clock grob placed into current menu )

* End of the clock display routine.

    LiteSlp
   ;
   GETTOUCH
   UNTIL
   GOTKEY
  ;
  caseTRUE ATTN?
  case ATTNxcp
  SAVELCD? case LCDxcp
  ALARM? case ALARMxcp
  TIMEOUT? case SLEEPxcp
  UART? case UARTxcp
 ;
 NOBLINK
 case H/WKey>KeyOb
 NOTcase nGetKeyOb

* In the HP48, CtlAlarm! should be here, but alarms are disabled in the 38G.

 ' DoCAlarmKey
;

******************************************************************************

* RunningErr just displays an error message. Since it is called twice, we save
* a few bytes if it's placed in a ROMPTR.

NULLNAME RunningErr
::
  $ "CLK is running!"
  DoAlert                       ( Displays a message box with an alert icon )
;

******************************************************************************

* The library configuration routine. Libraries are automatically attached when
* downloaded, but it's necessary when a warmstart (ON+SK3) occurs.

NULLNAME libcfg
::
 # 702 TOSRRP
;

******************************************************************************
